<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Faisan Guestbook Setup
// Product: Faisan GuestBook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    18/11/2009
// Updated: 08/04/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: setup.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

session_start();

ini_set('arg_separator.output','&amp;');
define('IN_SCRIPT', true);
//define('DEBUG', true);

require_once('appConfig.php');
require_once($cf_sourcePath.'/util/fileManager.php');
require_once($cf_sourcePath.'/util/commonF.php');

$page = 0;

if ($cf_isInstalled == 0)
	$page = 1;

// Setup functions
function tplHeader($cf_appName, $cf_appProduct) {
	echo '<html>
			<head>
				<title>'.$cf_appName.' '.$cf_appProduct.' Setup</title>
				<link rel="shortcut icon" href="web/img/ico/favicon.ico" type="image/x-icon" />
				
				<style type="text/css">
					body {
						background-color: #646464;
						padding: 0px 0px 0px 0px;
						text-align: center;
						margin: 0px;
						font-family: arial, verdana;
						font-size: 10pt;
						color: #444444;
					}

					img {
						border: 0px;
					}

					a {
						text-decoration: none;
						font-weight: bold;
						color: #4D5582;
					} 

					a:hover {
						text-decoration: none;
						font-weight: bold;
						color: #4A54B9;
					}

					h1 {
						font-size: 20pt;
						margin-top: 0px;
					}
					
					input, select {
						margin-bottom: 5px;
					}
					
					#pageHeader {
						background-color: #3C57C4;
						color: #FFFFFF;
					}

					#mainPanel {
						width: 700px;
						background-color: #D4D4D4;
						border: 1px solid #444444;
						margin: 0px auto;
						text-align: left;
					}

					#content {
						background-color: transparent;
						text-align: left;
						padding: 5px 10px 5px 10px;
					}

					#pageFooter {
						width: 700px;
						clear: both;
						background-color: #FFFFFF;
						font-size: 8pt;
						color: #000000;
						margin: 0px auto;
						padding: 5px 0px 5px 0px;
					}

					#license {
						text-align: center;
						background-color: #FFFFFF;
						border: 1px solid #444444;
						padding: 5px 5px 5px 5px;
					}

					label.lblForm {
						width: 160px;
						float: left;
					}

					div.errorMessage {
						margin-top: 10px;
						color: #000000;
						padding: 2px 10px 2px 10px;
						background-color: #FBFBBF;
						border-top: 1px solid #E8B031;
						border-bottom: 1px solid #E8B031;
					}					
				</style>
				
				<script type="text/javascript">
					function activeButton(event) {
						if (event == \'y\')
							document.getElementById(\'btNext\').disabled = false;
						else
							document.getElementById(\'btNext\').disabled = true;
					}
				</script>
			<head>

			<body>
				<div id="mainPanel">
					<div id="pageHeader">
						<img src="web/img/logos/faisanGBcover.png" alt="'.$cf_appName.' '.$cf_appProduct.' Setup" title="'.$cf_appName.' '.$cf_appProduct.' Setup" />
					</div>
			
					<div id="content">';
}

function tplFooter($cf_appName, $cf_appProduct) {
	echo '			</div>
				</div>
				<div id="pageFooter">
					<p>'.$cf_appName.' '.$cf_appProduct.' is Free Software released under the GNU/GPL License.</p>
				</div>
			</body>
		</html>';
}

// Get action
$action = '';
$formAction = '';

if (isset($_POST['action'])) {
	$action = htmlentities($_POST['action'], ENT_QUOTES);
}
elseif (isset($_GET['action'])) {
	$action = htmlentities($_GET['action'], ENT_QUOTES);
}

//----------------------
// Setup backend actions
//----------------------
$pageError = array();
$actionMade = 0;
$strToInsert = '';

if ($action == 'passLicense') {
	$page = 2;
	$formAction = 'saveConfig';
}
elseif ($action == 'saveConfig') {
	// Updating _config.php file
	$appIsInstalled = 1;
	
	$appVersion = htmlentities($_POST['appVersion'], ENT_QUOTES);
	$appPath = htmlentities($_POST['txAppPath'], ENT_QUOTES);
	$appDataPath = htmlentities($_POST['txDataPath'], ENT_QUOTES);
	$appAdminPath = htmlentities($_POST['txAdminPath'], ENT_QUOTES);
	$appLangPath = htmlentities($_POST['txLangPath'], ENT_QUOTES);
	$appThemePath = htmlentities($_POST['txThemePath'], ENT_QUOTES);
	
	// Validating fields
	if (cf_validateRequiredField($appPath) != 0)
		$pageError[] = 'Application Path is required.';		
	if (cf_validateRequiredField($appDataPath) != 0)
		$pageError[] = 'Data Path is required.';		
	if (cf_validateRequiredField($appAdminPath) != 0)
		$pageError[] = 'Admin Path is required.';		
	if (cf_validateRequiredField($appLangPath) != 0)
		$pageError[] = 'Lang Path is required.';
	if (cf_validateRequiredField($appThemePath) != 0)
		$pageError[] = 'Theme Path is required.';
	
	if (count($pageError) == 0) {
		$strToInsert = '<?php'."\n".
					 '$cf_isInstalled = '.$appIsInstalled.';'."\n".
					 '$cf_appName = \''.$cf_appName.'\';'."\n".
					 '$cf_appProduct = \''.$cf_appProduct.'\';'."\n".
					 '$cf_appVersion = \''.$appVersion.'\';'."\n".
					 '$cf_appPath = \''.$appPath.'\';'."\n".
					 '$cf_dataPath = \''.$appDataPath.'\';'."\n".
					 '$cf_adminPath = \''.$appAdminPath.'\';'."\n".
					 '$cf_sourcePath = \'app/src\';'."\n".
					 '$cf_langPath = \''.$appLangPath.'\';'."\n".
					 '$cf_themePath = \''.$appThemePath.'\';'."\n".
					 '?>';
		
		if (defined('DEBUG'))
			echo "<!--\nOutput generated by strToInsert\n$strToInsert\n-->\n";
		else {
			// Saving file...
			$saveFile = new fileManager('appConfig.php', 'w');
			$saveFile->saveData($strToInsert);
		}		
		$page = 3;
		$formAction = 'saveAccount';
	} else {
		$page = 2;
		$formAction = 'saveConfig';
	}
}
elseif ($action == 'saveAccount') {
	$userName = htmlentities($_POST['txUserName'], ENT_QUOTES);
	$userPass = htmlentities($_POST['txUserPass'], ENT_QUOTES);
	$UserConfirmPass = htmlentities($_POST['txUserConfirmPass'], ENT_QUOTES);
	
	// Validating fields
	if (cf_validateRequiredField($userName) != 0)
		$pageError[] = 'User name is required.';		
	if (cf_validateRequiredField($userPass) != 0)
		$pageError[] = 'User password is required.';
	else {
		$userPass = md5($userPass);
		$UserConfirmPass = md5($UserConfirmPass);		
		if ($userPass != $UserConfirmPass)	
			$pageError[] = 'Password and confirm password does not match.';
	}
	
	if (count($pageError) == 0) {
		$userId = 0;
		$userFile = new fileManager($cf_dataPath.'/users.php', 'r');
		if ($userFile->getRows() == 0)
			$userId = 1;
		else {
			$tmpId = explode('|', $userFile->getDataRow(($userFile->getRows()-1)));
			$userId = $tmpId[0]+1;
		}
		$userFile->closeFile();
		
		$strToInsert = $userId.'|'.
					   $userName.'|'.
					   $userPass.'||||'.
					   cf_getUTCTime().'|'."\n";
					   
		if (defined('DEBUG'))
			echo "<!--\nOutput generated by strToInsert\n$strToInsert\n-->\n";
		else {
			// Saving file...						 
			$saveFile = new fileManager($cf_dataPath.'/users.php', 'a');
			$saveFile->saveData($strToInsert);
		}		
		$page = 4;
		$formAction = 'saveDataConfig';
	} else {
		$page = 3;
		$formAction = 'saveAccount';
	}
}
elseif ($action == 'saveDataConfig') {
	$pageName = htmlentities($_POST['txPageName'], ENT_QUOTES);
	$pageUrl = htmlentities($_POST['txPageUrl'], ENT_QUOTES);
	$timeZone = htmlentities($_POST['txTimeZone'], ENT_QUOTES);
	$appLang = htmlentities($_POST['txAppLang'], ENT_QUOTES);
	
	// Validating fields
	if (cf_validateRequiredField($pageName) != 0)
		$pageError[] = 'Page name is required.';
	if (cf_validateWebsite($pageUrl) != 0)
		$pageError[] = 'You must enter a valid website url.';
		
	if (count($pageError) == 0) {
		$configFile = new fileManager($cf_dataPath.'/config.php', 'r');
		
		$strToInsert = '<?php'."\n".
					   '$cf_pageName = \''.$pageName.'\';'."\n".
					   '$cf_pageURL = \''.$pageUrl.'\';'."\n".
					   $configFile->getDataRow(3).
					   $configFile->getDataRow(4).
					   '$cf_appLang = \''.$appLang.'\';'."\n".
					   $configFile->getDataRow(6).
					   '$cf_timeZone = '.$timeZone.';'."\n".
					   $configFile->getDataRow(8).
					   $configFile->getDataRow(9).
					   $configFile->getDataRow(10).
					   $configFile->getDataRow(11).
					   $configFile->getDataRow(12).
					   $configFile->getDataRow(13).
					   $configFile->getDataRow(14).
					   $configFile->getDataRow(15).
					   $configFile->getDataRow(16).
					   $configFile->getDataRow(17).
					   $configFile->getDataRow(18).
					   $configFile->getDataRow(19).
					   $configFile->getDataRow(20).
					   $configFile->getDataRow(21).
					   $configFile->getDataRow(22).
					   $configFile->getDataRow(23).
					   $configFile->getDataRow(24).
					   '?>';
					   
		if (defined('DEBUG'))
			echo "<!--\nOutput generated by strToInsert\n$strToInsert\n-->\n";
		else {
			// Saving file...						 
			$saveFile = new fileManager($cf_dataPath.'/config.php', 'w');
			$saveFile->saveData($strToInsert);
		}		
		$page = 5;
	} else {
		$page = 4;
		$formAction = 'saveDataConfig';
	}
}
elseif ($action == 'newAccount') {
	$page = 6;
	$formAction = 'saveNewAccount';
}
elseif ($action == 'saveNewAccount') {
	$userName = htmlentities($_POST['txUserName'], ENT_QUOTES);
	$userPass = htmlentities($_POST['txUserPass'], ENT_QUOTES);
	$UserConfirmPass = htmlentities($_POST['txUserConfirmPass'], ENT_QUOTES);
	
	// Validating fields
	if (cf_validateRequiredField($userName) != 0)
		$pageError[] = 'User name is required.';		
	if (cf_validateRequiredField($userPass) != 0)
		$pageError[] = 'User password is required.';
	else {
		$userPass = md5($userPass);
		$UserConfirmPass = md5($UserConfirmPass);		
		if ($userPass != $UserConfirmPass)	
			$pageError[] = 'Password and confirm password does not match.';
	}
	
	if (count($pageError) == 0) {
		$userId = 0;
		$userFile = new fileManager($cf_dataPath.'/users.php', 'r');
		if ($userFile->getRows() == 0)
			$userId = 1;
		else {
			$tmpId = explode('|', $userFile->getDataRow(($userFile->getRows()-1)));
			$userId = $tmpId[0]+1;
		}
		$userFile->closeFile();
		
		$strToInsert = $userId.'|'.
					   $userName.'|'.
					   $userPass.'||||'.
					   cf_getUTCTime().'|'."\n";
					   
		if (defined('DEBUG'))
			echo "<!--\nOutput generated by strToInsert\n$strToInsert\n-->\n";
		else {
			// Saving file...						 
			$saveFile = new fileManager($cf_dataPath.'/users.php', 'a');
			$saveFile->saveData($strToInsert);
		}		
		$page = 7;
	} else {
		$page = 6;
		$formAction = 'saveNewAccount';
	}
}

//---------------------
// Setup frontpage page
//---------------------
tplHeader($cf_appName, $cf_appProduct);

if ($page == 0) {
	echo '<h2>Warning</h2>

		<p>'.$cf_appName.' '.$cf_appProduct.' '.$cf_appVersion.' is already installed on your server.</p>
		<p>Delete this file in order to avoid security risks.</p>
		<p><a href="?action=newAccount">Create a new administrator account</a></p>
		<p><a href="index.php">View my Guestbook</a></p>';
}
elseif ($page == 1) {
	echo '<p>Welcome. This will install '.$cf_appName.' '.$cf_appProduct.' '.$cf_appVersion.'</p>
			<p>Please read the following license agreement carefully.</p>';
			
	echo '<p><div id="license">
			<p><b>'.$cf_appName.' '.$cf_appProduct.'.</b></p>
			
			<p>Copyright (C) 2009 Adriel Media / Adriel Ricardo Torres N.</p>
			
			<p>This program is free software: you can redistribute it and/or modify
			it under the terms of the GNU General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.</p>

			<p>This program is distributed in the hope that it will be useful,
			but <b>WITHOUT ANY WARRANTY</b>; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU General Public License for more details.</p>

			<p>You should have received a copy of the GNU General Public License
			along with this program.  If not, see <b>http://www.gnu.org/licenses</b>.</p>
			</div></p>';
	
	echo '<form name="afForm" action="" method="post">
			<input type="hidden" name="action" value="passLicense" />
			<p>
				<input id="rbAg1" type="radio" name="rbAgreement" value="y" onClick="activeButton(\'y\')" /> <label for="rbAg1">I accept the terms in the license agreement</label>
				<br /><br />
				<input id="rbAg2" type="radio" name="rbAgreement" value="n" onClick="activeButton(\'n\')" checked="checked" /> <label for="rbAg2">I do not accept the terms in the license agreement</label>
			</p>
			<hr />
			<p style="text-align: right;">
				<input type="submit" id="btNext" name="btNext" value="Next &gt" disabled="disabled" />
			</p>
		</form>';
}
elseif ($page == 2) {

	$appPath = basename(dirname($_SERVER['REQUEST_URI']));

	echo '<h2>Application paths</h2>
	
		<p>Do not change this at least that you have renamed some directories used by application.</p>
	
		<form name="afForm" action="" method="post">
			<input type="hidden" name="action" value="'.$formAction.'" />
			<input type="hidden" name="appVersion" value="'.$cf_appVersion.'" />
			<p>
				<label class="lblForm">Application Path:</label><input type="text" name="txAppPath" value="'.$appPath.'" />
				<br />
				<label class="lblForm">Data Path:</label><input type="text" name="txDataPath" value="app/data" />
				<br />
				<label class="lblForm">Admin Panel Path:</label><input type="text" name="txAdminPath" value="admin" />
				<br />
				<label class="lblForm">Language Path:</label><input type="text" name="txLangPath" value="app/lang" />
				<br />
				<label class="lblForm">Themes Path:</label><input type="text" name="txThemePath" value="web/themes" />
			</p>
			<hr />
			<p style="text-align: right;">
				<!--<input type="button" id="btBack" name="btBack" value="&lt Back" onClick="history.go(-1);" />-->
				<input type="submit" id="btNext" name="btNext" value="Next &gt" />
			</p>
		</form>';
}
elseif ($page == 3) {
	echo '<h2>Create your admin account.</h2>
	
		<form name="afForm" action="" method="post">
			<input type="hidden" name="action" value="'.$formAction.'" />
			<p>
				<label class="lblForm">Username:</label><input type="text" name="txUserName" />
				<br />
				<label class="lblForm">Password:</label><input type="password" name="txUserPass" />
				<br />
				<label class="lblForm">Confirm password:</label><input type="password" name="txUserConfirmPass" />
			</p>
			<hr />
			<p style="text-align: right;">
				<input type="submit" id="btNext" name="btNext" value="Next &gt" />
			</p>
		</form>';
}
elseif ($page == 4) {
	echo '<h2>Guestbook seetings.</h2>
	
		<form name="afForm" action="" method="post">
			<input type="hidden" name="action" value="'.$formAction.'" />
			<p>
				<label class="lblForm">Website name:</label><input type="text" name="txPageName" />
				<br />
				<label class="lblForm">Website URL:</label><input type="text" name="txPageUrl" value="http://" />
				<br />
				<label class="lblForm">Time zone:</label><select name="txTimeZone">'.cf_getOptionTimeZone(0).'</select>
				<br />
				<label class="lblForm">Guestbook language:</label><select name="txAppLang">'.cf_getOptionDir('english', $cf_langPath).'</select>
			</p>
			<hr />
			<p style="text-align: right;">
				<input type="submit" id="btNext" name="btNext" value="Next &gt" />
			</p>
		</form>';
}
elseif ($page == 5) {
	echo '<h2>Congratulations</h2>
		
		<p>Thanks for installing '.$cf_appName.' '.$cf_appProduct.' '.$cf_appVersion.'</p>
		<p>Delete this file in order to avoid security risks.</p>
		<p><a href="index.php">View my Guestbook</a></p>';
}
elseif ($page == 6) {
	echo '<h2>Create a new admin account.</h2>
	
		<form name="afForm" action="" method="post">
			<input type="hidden" name="action" value="'.$formAction.'" />
			<p>
				<label class="lblForm">Username:</label><input type="text" name="txUserName" />
				<br />
				<label class="lblForm">Password:</label><input type="password" name="txUserPass" />
				<br />
				<label class="lblForm">Confirm password:</label><input type="password" name="txUserConfirmPass" />
			</p>
			<hr />
			<p style="text-align: right;">
				<input type="submit" id="btNext" name="btNext" value="Next &gt" />
			</p>
		</form>';
}
elseif ($page == 7) {
	echo '<h2>Admin account successfully created</h2>
		
		<p>Delete this file in order to avoid security risks.</p>
		<p><a href="index.php">View my Guestbook</a></p>';
}
else {
	echo '<p><b>Ops!</b>, an error occured when installing the application, please refresh this page</p>';
}

if (count($pageError) > 0) {
	echo '<div class="errorMessage">';
	for ($i = 0; $i < count($pageError); $i++)
		echo '<b>'.$pageError[$i].'</b><br />';
	echo '</div>';
}

tplFooter($cf_appName, $cf_appProduct);

?>