<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Application Header
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    24/11/2009
// Updated: 20/07/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: appHeader.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
session_start();

ini_set('arg_separator.output','&amp;');
define('IN_SCRIPT', true);

//define('DEBUG', true); // Uncomment this line only if you want debug the application
$debug = array();

// Loading configuration files
require_once('appConfig.php');

if ($cf_isInstalled == 0) {
	// Application is not installed
	die("<b>[Warning]</b> $cf_appName $cf_appProduct $cf_appVersion isn't installed on server.");
}

require_once($cf_dataPath.'/config.php');

if ($cf_isOffline == 1) {
	// Application is in offline mode
	die("<b>[Offline]</b> $cf_offlineMsg");
}

// Loading source for application
require_once($cf_sourcePath.'/owner/hfoClassAPP.php');
require_once($cf_sourcePath.'/owner/langBoxAPP.php');

// Loading utilities source
require_once($cf_sourcePath.'/util/amCode.php');
require_once($cf_sourcePath.'/util/amPaginator.php');
require_once($cf_sourcePath.'/util/fileManager.php');
require_once($cf_sourcePath.'/util/replaceString.php');
require_once($cf_sourcePath.'/util/templateParser.php');
require_once($cf_sourcePath.'/util/commonF.php');
require_once($cf_sourcePath.'/util/antiSpamClass.php');

// Loading VO classes
require_once($cf_sourcePath.'/vo/commentsVO.php');
require_once($cf_sourcePath.'/vo/usersVO.php');
require_once($cf_sourcePath.'/vo/itemsVO.php');
require_once($cf_sourcePath.'/vo/smileysVO.php');

// Defining application constants and variables
define('COMMENTS_FIELDS', 10);

// Initializing template variables
$tplVars = array();
$tplPath = $cf_themePath;

// Loading output language
$guest_language = '';

if (isset($_SESSION['Lang']) && is_file($cf_langPath.'/'.htmlentities($_SESSION['Lang'], ENT_QUOTES).'.inc')) {
	require_once($cf_langPath.'/'.$_SESSION['Lang'].'.inc');
	$currentLang = $_SESSION['Lang'];
}
else {
	require_once($cf_langPath.'/'.$cf_appLang.'.inc');
	$currentLang = $cf_appLang;
}

$ipFile = new fileManager($cf_dataPath.'/ipLog', 'r');
if (cf_isBanned(cf_getIp(), $ipFile->getAllDataRows()) != 0) {
	// User Ip address is banned
	die('<b>[Banned]</b> '.$langMsg['Banned_message']);
}

// Loading main header/footer output template class
$mainTpl = new hfoClassAPP($tplPath, $cf_appTheme, $cf_sourcePath, $langMsg, $cf_pageName, $cf_pageURL, $cf_dateFormat, $cf_timeZone, $cf_signPage, $langMsg['Sign_guestbook']);

$tplPath = $cf_themePath.'/'.$cf_appTheme;
?>