<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Template Parser Class
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    01/04/2009
// Updated: 26/11/2009
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: templateParser.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') )
{
	die('Script interrupted.');
	exit;
}

class templateParser {
	protected $cv_file, $cv_lines, $cv_array_data, $cv_msg, $cv_output_data, $cv_output;
	
	public function __construct($tpl_path, $tpl_array_data) {
		if (is_file($tpl_path)) {
			$this->cv_file = @file($tpl_path);
			$this->cv_lines = count($this->cv_file);
			$this->cv_array_data = $tpl_array_data;
			$this->cv_msg = '[Class_templateParser] ['.date(DATE_RFC822).'] File successfuly opened.';
			$this->parseData();
		} else {
			$this->cv_msg = '[Class_templateParser] ['.date(DATE_RFC822).'] [Error] File does not exist: '.$tpl_path;
			$this->cv_output = '';
		}
	}

	public function parseData() {
		for ($i = 0; $i < $this->cv_lines; $i++) {
			reset($this->cv_array_data);

			while (list($key, $val) = each($this->cv_array_data)) {
				$this->cv_file[$i] = str_replace($key, $val, $this->cv_file[$i]);
			}
			$this->cv_output_data .= $this->cv_file[$i];
		}
		$this->cv_output = $this->cv_output_data;
	}
	
	public function getMessage() {
		return $this->cv_msg;
	}

	public function __toString() {
		return $this->cv_output;
	}
}
?>