<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Anti Spam Class
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    01/12/2009
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: antiSpamClass.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') ) {
	die('Script interrupted.');
	exit;
}

class antiSpamClass {
	protected $cv_strText, $cv_iPts, $cv_spamKeys, $cv_spamKeysRows;

	public function __construct($spamKeys) {
		$this->cv_strText = '';
		$this->cv_iPts = 0;
		$this->cv_spamKeys = $spamKeys;
		$this->cv_spamKeysRows = count($spamKeys);
	}
	
	public function getSpamPoints() {
		return $this->cv_iPts;
	}
	
	public function checkTextArea($strText) {
		$this->cv_strText = $strText;
		$this->strLength(30);
		$this->countLinks();
		$this->countSpamKeys();
		
		return $this->cv_iPts;
	}
	
	public function checkNameField($strText) {
		$this->cv_strText = $strText;
		$this->findString('http://');
		$this->countSpamKeys();
	}
	
	public function checkUrlField($strText) {
		$this->cv_strText = $strText;
		$this->strLengthUrl(40);
		$this->countSpamKeys();
	}
	
	protected function countLinks() {
		if (substr_count($this->cv_strText, 'http://') != 0)
			$this->cv_iPts = $this->cv_iPts - 2;
	}
	
	protected function strLength($maxNum) {
		if (strlen($this->cv_strText) > $maxNum)
			$this->cv_iPts = $this->cv_iPts + 2;
	}
	
	protected function strLengthUrl($maxNum) {
		if (strlen($this->cv_strText) > $maxNum)
			$this->cv_iPts--;
	}
	
	protected function findString($strVar) {
		if (substr_count($this->cv_strText, $strVar) != 0)
			$this->cv_iPts = $this->cv_iPts - 2;
	}
	
	protected function countSpamKeys() {
		for ($i=0; $i<$this->cv_spamKeysRows; $i++) {
			$arrKey = explode('|', $this->cv_spamKeys[$i]);
		
			if (substr_count(strtolower($this->cv_strText), strtolower($arrKey[1])) != 0)
				$this->cv_iPts--;
		}
	}
}
?>