<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Adriel Media  Paginator Class
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    27/11/2009
// Updated: 09/12/2009
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: amPaginator.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') )
{
	die('Script interrupted.');
	exit;
}

class amPaginator {
	protected $cv_numComments, $cv_iPage, $cv_commentPPage, $cv_totalPages, $cv_pagOutput, $cv_limit, $cv_initial, $cv_maxResults;
	
	public function __construct($numComments, $iPage, $commentsPPage, $maxResults) {
		$this->cv_numComments = $numComments;
		$this->cv_pagesPComment = $commentsPPage;
		$this->cv_totalPages = ceil($numComments / $commentsPPage);
		$this->cv_maxResults = $maxResults;
		$this->cv_pagOutput = '';
		
		if ($iPage <= $this->cv_totalPages)
			$this->cv_iPage = $iPage;
		else
			$this->cv_iPage = 1;

		$this->cv_limit = ($this->cv_iPage * $commentsPPage);
		$this->cv_initial = ($this->cv_limit - $commentsPPage);
	}

	public function getPaginator() {
		if ($this->cv_totalPages > 1) {
			// First output
			if ($this->cv_iPage > 1) {
				if ($this->cv_iPage == 2) {
					$this->cv_pagOutput .= '<a href="?page='.($this->cv_iPage - 1).'">&lt;</a> ';
				} else {
					$this->cv_pagOutput .= '<a href="?page=1">&lt;&lt;</a> <a href="?page='.($this->cv_iPage - 1).'">&lt;</a> ';
				}
			}
			
			$limitPage = 0;
			
			// Second output
			for ($i=$this->cv_iPage; $i<=$this->cv_totalPages && $i<($this->cv_maxResults+$this->cv_iPage); $i++) {
				if ($i == $this->cv_iPage)
					$this->cv_pagOutput .= '<b>'.$i.'</b> ';
				else
					$this->cv_pagOutput .= '<a href="?page='.$i.'">'.$i.'</a> ';
				
				$limitPage = $i;
			}
			
			// Third output
			if ($this->cv_iPage != $this->cv_totalPages) {
				if ($this->cv_totalPages == $limitPage)
					$this->cv_pagOutput .= '<a href="?page='.($this->cv_iPage + 1).'">&gt;</a>';
				else
					$this->cv_pagOutput .= '<a href="?page='.($this->cv_iPage + 1).'">&gt;</a> <a href="?page='.$this->cv_totalPages.'">&gt;&gt;</a>';
			}
		}
		
		return $this->cv_pagOutput;
	}

	public function getLimit() {
		return $this->cv_limit;
	}
	
	public function getThisPage() {
		return $this->cv_iPage;
	}
	
	public function getInitial() {
		return $this->cv_initial;
	}
	
	public function getTotalPages() {	
		if ($this->cv_totalPages == 0)
			return 1;
		else
			return $this->cv_totalPages;
	}
}
?>