<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Language box class
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    26/11/2009
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: langBoxAPP.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') ) {
	die('Script interrupted.');
	exit;
}

class langBoxAPP {
	protected $cv_langPath, $cv_userLang;

	public function __construct($langPath, $userLang) {
		$this->cv_langPath = $langPath;
		$this->cv_userLang = $userLang;
	}

	public function setUserLang($userLang) {
		$this->cv_userLang = $userLang;
	}

	public function showLangBox() {
		$strLangBox = '';

		if (is_dir($this->cv_langPath))
		{
			$strLangBox = '<form name="modFormLang" action="" method="post">
					<select name="modLangBox" onchange="modFormLang.submit()">';					
					
			if ($dirData = opendir($this->cv_langPath)) {
				while (($dataFile = readdir($dirData)) != false) {
					if ($dataFile != '.' && $dataFile != '..' && $dataFile != 'index.html')	{
						$arrLangName = explode('.', $dataFile);

						if ($this->cv_userLang == $arrLangName[0])
							$strLangBox .= '<option value="'.$arrLangName[0].'" selected="selected">'.$arrLangName[0].'</option>';
						else
							$strLangBox .= '<option value="'.$arrLangName[0].'">'.$arrLangName[0].'</option>';
					}
				}
				closedir($dirData);
			}
			
			$strLangBox .= '</select>
						</form>';
		}		
		return $strLangBox;
	}
}
?>