<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Header and Footer Output Class
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    26/11/2009
// Updated: 28/07/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: hfoClassAPP.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') )
{
	die('Script interrupted.');
	exit;
}

class hfoClassAPP {
	protected $cv_tplPath, $cv_appTheme, $cv_surcePath, $cv_langMsg, $cv_msg, $cv_tplVars, $cv_pageName, $cv_pageUrl, $cv_dateFormat, $cv_timeZone, $cv_lnkPage, $cv_txtPage;
	
	public function __construct($tplPath, $appTheme, $sourcePath, $langMsg, $pageName, $pageUrl, $dateFormat, $timeZone, $lnkPage, $txtPage) {
		$this->cv_tplPath = $tplPath;
		$this->cv_appTheme = $appTheme;
		$this->cv_surcePath = $sourcePath;
		$this->cv_langMsg = $langMsg;
		$this->cv_pageName = $pageName;
		$this->cv_pageUrl = $pageUrl;
		$this->cv_dateFormat = $dateFormat;
		$this->cv_timeZone = $timeZone;
		$this->cv_lnkPage = $lnkPage;
		$this->cv_txtPage = $txtPage;
		$this->cv_tplVars = array();
	}

	public function showHeader() {
		$this->cv_tplVars['{ENCODING}'] = $this->cv_langMsg['Encoding'];
		$this->cv_tplVars['{DIRECTION}'] = $this->cv_langMsg['Direction'];
		$this->cv_tplVars['{LANG}'] = $this->cv_langMsg['Lang'];
		$this->cv_tplVars['{TEMPLATE_PATH}'] = $this->cv_tplPath;
		$this->cv_tplVars['{SOURCE_PATH}'] = $this->cv_surcePath;
		$this->cv_tplVars['{TITLE}'] = $this->cv_pageName;
		$this->cv_tplVars['{TODAY_DATE}'] = cf_getTodayDate($this->cv_dateFormat, $this->cv_timeZone);
		$this->cv_tplVars['{TXT_HOME}'] = $this->cv_langMsg['Home'];
		$this->cv_tplVars['{LNK_HOME}'] = $this->cv_pageUrl;
		$this->cv_tplVars['{TXT_VIEW_SIGN}'] = $this->cv_txtPage;
		$this->cv_tplVars['{LNK_VIEW_SIGN}'] = $this->cv_lnkPage;
		
		if ($this->cv_langMsg['Direction'] == 'ltr')
			$this->cv_tplVars['{STYLE_CONTENT}'] = '';
			
		echo (new templateParser($this->cv_tplPath.'/'.$this->cv_appTheme.'/tpl/mainHeader.html', $this->cv_tplVars));
	}
	
	public function showFooter() {
		$this->cv_tplVars['{LNK_ADMIN_CP}'] = 'admin';
		$this->cv_tplVars['{TXT_ADMIN_CP}'] = $this->cv_langMsg['Admin_CP'];
		$this->cv_tplVars['{CREDITS}'] = 'Powered by <a href="http://www.adrielmedia.com">Faisan Guestbook</a>';

		echo (new templateParser($this->cv_tplPath.'/'.$this->cv_appTheme.'/tpl/mainFooter.html', $this->cv_tplVars));
	}
	
	public function setLangMsg($langMsg) {
		$this->cv_langMsg = $langMsg;
	}
	
	public function setLnkPage($lnkPage, $txtPage) {
		$this->cv_lnkPage = $lnkPage;
		$this->cv_txtPage = $txtPage;
	}
}
?>