<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Header and Footer Output Class for Admin Control Panel
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    09/12/2009
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: hfoAdminClassAPP.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------

//Detect external attacks and intrusions.
if ( !defined('IN_SCRIPT') ) {
	die('Script interrupted.');
	exit;
}

class hfoAdminClassAPP {
	protected $cv_tplPath, $cv_sourcePath, $cv_langMsg, $cv_msg, $cv_tplVars, $cv_pageName;
	
	public function __construct($tplPath, $sourcePath, $langMsg, $pageName) {
		$this->cv_tplPath = $tplPath;
		$this->cv_sourcePath = $sourcePath;
		$this->cv_langMsg = $langMsg;
		$this->cv_pageName = $pageName;
		$this->cv_tplVars = array();
	}

	public function showHeader($isLogged) {
		$this->cv_tplVars['{ENCODING}'] = $this->cv_langMsg['Encoding'];
		$this->cv_tplVars['{DIRECTION}'] = $this->cv_langMsg['Direction'];
		$this->cv_tplVars['{LANG}'] = $this->cv_langMsg['Lang'];
		$this->cv_tplVars['{TITLE}'] = $this->cv_pageName;
		$this->cv_tplVars['{SOURCE_PATH}'] = $this->cv_sourcePath;
		
		if ($this->cv_langMsg['Direction'] == 'ltr')
			$this->cv_tplVars['{STYLE_CONTENT}'] = '';

		if ($isLogged == 1) {
			$this->cv_tplVars['{HOME}'] = '<a href="index.php">'.$this->cv_langMsg['Home'].'</a>';
			$this->cv_tplVars['{LOGOUT}'] = '<a href="?logout=true">'.$this->cv_langMsg['Logout'].'</a>';
		} else {
			$this->cv_tplVars['{HOME}'] = '';
			$this->cv_tplVars['{LOGOUT}'] = '';
		}

		echo (new templateParser("../$this->cv_tplPath/tpl/mainHeader.html", $this->cv_tplVars));
	}
	
	public function showFooter() {
		echo (new templateParser("../$this->cv_tplPath/tpl/mainFooter.html", $this->cv_tplVars));
	}
}
?>