<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Configuration file page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    08/12/2009
// Updated: 07/02/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: mng_config.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$pageError = array();
$actionMade = 0;

if ($action == 'saveData' && is_writable('../'.$cf_dataPath.'/config.php')) {
	$tmp_pageName = htmlentities($_POST['pageName'], ENT_QUOTES);
	$tmp_pageURL = htmlentities($_POST['pageURL'], ENT_QUOTES);
	$tmp_cookieName = htmlentities($_POST['cookieName'], ENT_QUOTES);
	$tmp_signPage = htmlentities($_POST['signPage'], ENT_QUOTES);
	$tmp_appLang = htmlentities($_POST['appLang'], ENT_QUOTES);	
	$tmp_appTheme = htmlentities($_POST['appTheme'], ENT_QUOTES);
	$tmp_timeZone = htmlentities($_POST['timeZone'], ENT_QUOTES);
	$tmp_dateFormat = htmlentities($_POST['dateFormat'], ENT_QUOTES);
	$tmp_isOffline = htmlentities($_POST['isOffline'], ENT_QUOTES);
	$tmp_offlineMsg = htmlentities($_POST['offlineMsg'], ENT_QUOTES);	
	$tmp_toApproveComment = htmlentities($_POST['toApproveComment'], ENT_QUOTES);
	$tmp_notificationEmail = htmlentities($_POST['notificationEmail'], ENT_QUOTES);
	$tmp_showLangBox = htmlentities($_POST['showLangBox'], ENT_QUOTES);
	$tmp_showSecCode = htmlentities($_POST['showSecCode'], ENT_QUOTES);
	$tmp_showWebsiteField = htmlentities($_POST['showWebsiteField'], ENT_QUOTES);	
	$tmp_showEmailField = htmlentities($_POST['showEmailField'], ENT_QUOTES);
	$tmp_showLocationField = htmlentities($_POST['showLocationField'], ENT_QUOTES);
	$tmp_commentsPPage = htmlentities($_POST['commentsPPage'], ENT_QUOTES);
	$tmp_maxCommentChars = htmlentities($_POST['maxCommentChars'], ENT_QUOTES);
	$tmp_maxCommentBreakLines = htmlentities($_POST['maxCommentBreakLines'], ENT_QUOTES);	
	$tmp_timeBeforePostAgain = htmlentities($_POST['timeBeforePostAgain'], ENT_QUOTES);
	$tmp_allowBadWords = htmlentities($_POST['allowBadWords'], ENT_QUOTES);
	$tmp_allowAMcode = htmlentities($_POST['allowAMcode'], ENT_QUOTES);
	$tmp_allowSmileys = htmlentities($_POST['allowSmileys'], ENT_QUOTES);
	
	// Validating fields
	if (cf_validateRequiredField($tmp_pageName) != 0)
		$pageError[] = $langMsg['Page_name_warn'];
	
	if (cf_validateWebsite($tmp_pageURL) != 0)
		$pageError[] = $langMsg['Website_warn'];
		
	if (cf_validateRequiredField($tmp_cookieName) != 0)
		$pageError[] = $langMsg['Cookie_warn'];
	
	if (cf_validateRequiredField($tmp_signPage) != 0)
		$pageError[] = $langMsg['Sign_page_warn'];
	
	if (cf_validateRequiredField($tmp_dateFormat) != 0)
		$pageError[] = $langMsg['Date_format_warn'];
		
	if (cf_validateRequiredField($tmp_offlineMsg) != 0)
		$pageError[] = $langMsg['Offline_msg_warn'];

	if (cf_validateRequiredField($tmp_commentsPPage) != 0)
		$pageError[] = $langMsg['CommentsPPage_empty_warn'];
	elseif (cf_validateNumericField($tmp_commentsPPage) != 0)
		$pageError[] = $langMsg['CommentsPPage_warn'];
		
	if (cf_validateRequiredField($tmp_maxCommentChars) != 0)
		$pageError[] = $langMsg['MaxCommentChars_empty_warn'];
	elseif (cf_validateNumericField($tmp_maxCommentChars) != 0)
		$pageError[] = $langMsg['MaxCommentChars_warn'];
		
	if (cf_validateRequiredField($tmp_maxCommentBreakLines) != 0)
		$pageError[] = $langMsg['MaxCommentBreakLines_empty_warn'];
	elseif (cf_validateNumericField($tmp_maxCommentBreakLines) != 0)
		$pageError[] = $langMsg['MaxCommentBreakLines_warn'];
		
	if (cf_validateRequiredField($tmp_timeBeforePostAgain) != 0)
		$pageError[] = $langMsg['TimeBeforePostAgain_empty_warn'];
	elseif (cf_validateNumericField($tmp_timeBeforePostAgain) != 0)
		$pageError[] = $langMsg['TimeBeforePostAgain_warn'];
		
	if ($tmp_toApproveComment == 1) {
		if (cf_validateRequiredField($tmp_notificationEmail) != 0)
			$pageError[] = $langMsg['Notification_Email_warn'];
		elseif (cf_validateEmail($tmp_notificationEmail) != 0)
			$pageError[] = $langMsg['Email_warn'];
	}
	
	if (count($pageError) == 0) {
		$strConfig = '<?php'."\n";
		$strConfig .= '$cf_pageName = \''.$tmp_pageName.'\';'."\n";
		$strConfig .= '$cf_pageURL = \''.$tmp_pageURL.'\';'."\n";
		$strConfig .= '$cf_cookieName = \''.$tmp_cookieName.'\';'."\n";
		$strConfig .= '$cf_signPage = \''.$tmp_signPage.'\';'."\n";
		$strConfig .= '$cf_appLang = \''.$tmp_appLang.'\';'."\n";
		$strConfig .= '$cf_appTheme = \''.$tmp_appTheme.'\';'."\n";
		$strConfig .= '$cf_timeZone = '.$tmp_timeZone.';'."\n";
		$strConfig .= '$cf_dateFormat = \''.$tmp_dateFormat.'\';'."\n";
		$strConfig .= '$cf_isOffline = '.$tmp_isOffline.';'."\n";
		$strConfig .= '$cf_offlineMsg = \''.$tmp_offlineMsg.'\';'."\n";
		$strConfig .= '$cf_toApproveComment = '.$tmp_toApproveComment.';'."\n";
		$strConfig .= '$cf_notificationEmail = \''.$tmp_notificationEmail.'\';'."\n";
		$strConfig .= '$cf_showLangBox = '.$tmp_showLangBox.';'."\n";
		$strConfig .= '$cf_showSecCode = '.$tmp_showSecCode.';'."\n";
		$strConfig .= '$cf_showWebsiteField = '.$tmp_showWebsiteField.';'."\n";
		$strConfig .= '$cf_showEmailField = '.$tmp_showEmailField.';'."\n";
		$strConfig .= '$cf_showLocationField = '.$tmp_showLocationField.';'."\n";
		$strConfig .= '$cf_commentsPPage = '.$tmp_commentsPPage.';'."\n";
		$strConfig .= '$cf_maxCommentChars = '.$tmp_maxCommentChars.';'."\n";
		$strConfig .= '$cf_maxCommentBreakLines = '.$tmp_maxCommentBreakLines.';'."\n";
		$strConfig .= '$cf_timeBeforePostAgain = '.$tmp_timeBeforePostAgain.';'."\n";
		$strConfig .= '$cf_allowBadWords = '.$tmp_allowBadWords.';'."\n";
		$strConfig .= '$cf_allowAMcode = '.$tmp_allowAMcode.';'."\n";
		$strConfig .= '$cf_allowSmileys = '.$tmp_allowSmileys.';'."\n";
		$strConfig .= '?>';
		
		$debug[] = "$strConfig\n";		
		$saveConfig = new fileManager('../'.$cf_dataPath.'/config.php', 'w');
		$saveConfig->saveData($strConfig);
		$actionMade = 1;
	}	
} else {
	$tmp_pageName = $cf_pageName;
	$tmp_pageURL = $cf_pageURL;
	$tmp_cookieName = $cf_cookieName;
	$tmp_signPage = $cf_signPage;
	$tmp_appLang = $cf_appLang;	
	$tmp_appTheme = $cf_appTheme;
	$tmp_timeZone = $cf_timeZone;
	$tmp_dateFormat = $cf_dateFormat;
	$tmp_isOffline = $cf_isOffline;
	$tmp_offlineMsg = $cf_offlineMsg;	
	$tmp_toApproveComment = $cf_toApproveComment;
	$tmp_notificationEmail = $cf_notificationEmail;
	$tmp_showLangBox = $cf_showLangBox;
	$tmp_showSecCode = $cf_showSecCode;
	$tmp_showWebsiteField = $cf_showWebsiteField;	
	$tmp_showEmailField = $cf_showEmailField;
	$tmp_showLocationField = $cf_showLocationField;
	$tmp_commentsPPage = $cf_commentsPPage;
	$tmp_maxCommentChars = $cf_maxCommentChars;
	$tmp_maxCommentBreakLines = $cf_maxCommentBreakLines;	
	$tmp_timeBeforePostAgain = $cf_timeBeforePostAgain;
	$tmp_allowBadWords = $cf_allowBadWords;
	$tmp_allowAMcode = $cf_allowAMcode;
	$tmp_allowSmileys = $cf_allowSmileys;
}
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin CP header
$mainTpl->showHeader($isLogged);

// Configuration body
$tplVars['{CONFIGURATION}'] = $langMsg['Configuration'];
$tplVars['{GENERAL}'] = $langMsg['General'];
$tplVars['{FIELD_SETTINGS}'] = $langMsg['Field_settings'];
$tplVars['{COMMENT_SETTINGS}'] = $langMsg['Comment_settings'];

// Constant vars
$tplVars['{GUESTBOOK_NAME_TEXT}'] = $langMsg['Guestbook_name'];
$tplVars['{HOMEPAGE_URL_TEXT}'] = $langMsg['Homepage_url'];
$tplVars['{COOKIE_NAME_TEXT}'] = $langMsg['Cookie_name'];
$tplVars['{SIGN_PAGE_TEXT}'] = $langMsg['Guestbook_sign_page'];
$tplVars['{DEFAULT_LANGUAGE_TEXT}'] = $langMsg['Default_language'];
$tplVars['{THEME_TEXT}'] = $langMsg['Theme'];
$tplVars['{TIME_ZONE_TEXT}'] = $langMsg['Time_zone'];
$tplVars['{DATE_FORMAT_TEXT}'] = $langMsg['Date_format'];
$tplVars['{GUESTBOOK_IS_OFFLINE_TEXT}'] = $langMsg['Offline_mode'];
$tplVars['{OFFLINE_MESSAGE_TEXT}'] = $langMsg['Offline_message'];
$tplVars['{APPROVE_COMMENTS_TEXT}'] = $langMsg['Approve_comments'];
$tplVars['{APPROVE_COMMENTS_TEXT_HELP}'] = $langMsg['Approve_comments_help'];
$tplVars['{NOTIFICATION_EMAIL_TEXT}'] = $langMsg['Notification_Email'];
$tplVars['{SHOW_LANGBOX_TEXT}'] = $langMsg['Show_language_box'];
$tplVars['{SHOW_VERIFICATION_CODE_TEXT}'] = $langMsg['Show_verification_code'];
$tplVars['{SHOW_VERIFICATION_CODE_HELP}'] = $langMsg['Show_verification_code_help'];
$tplVars['{SHOW_WEBSITE_FIELD_TEXT}'] = $langMsg['Show_website_field'];
$tplVars['{SHOW_EMAIL_FIELD_TEXT}'] = $langMsg['Show_email_field'];
$tplVars['{SHOW_LOCATION_FIELD_TEXT}'] = $langMsg['Show_location_field'];
$tplVars['{COMMENTS_PER_PAGE_TEXT}'] = $langMsg['Comments_per_page'];
$tplVars['{CHARACTERS_PER_COMMENT_TEXT}'] = $langMsg['Characters_per_comment'];
$tplVars['{PARAGRAPHS_PER_COMMENT_TEXT}'] = $langMsg['Paragraphs_per_comment'];
$tplVars['{FLOOD_TIME_LIMIT_TEXT}'] = $langMsg['Flood_time_limit'];
$tplVars['{FLOOD_TIME_LIMIT_TEXT_HELP}'] = $langMsg['Flood_time_limit_help'];
$tplVars['{ALLOW_BAD_WORDS_TEXT}'] = $langMsg['Allow_bad_words'];
$tplVars['{ALLOW_AMCODE_TEXT}'] = $langMsg['Allow_am_code'];
$tplVars['{ALLOW_SMILEYS_TEXT}'] = $langMsg['Allow_smileys'];
$tplVars['{SAVE_CHANGES}'] = $langMsg['Save_changes'];

// Dinamic vars
$tplVars['{GUESTBOOK_NAME_VALUE}'] = $tmp_pageName;
$tplVars['{HOMEPAGE_URL_VALUE}'] = $tmp_pageURL;
$tplVars['{COOKIE_NAME_VALUE}'] = $tmp_cookieName;
$tplVars['{SIGN_PAGE_VALUE}'] = $tmp_signPage;
$tplVars['{DEFAULT_LANGUAGE_VALUE}'] = cf_getOptionDir($tmp_appLang, '../'.$cf_langPath);
$tplVars['{THEME_VALUE}'] = cf_getOptionDir($tmp_appTheme, '../'.$cf_themePath);
$tplVars['{TIME_ZONE_VALUE}'] = cf_getOptionTimeZone($tmp_timeZone);
$tplVars['{DATE_FORMAT_VALUE}'] = $tmp_dateFormat;
$tplVars['{GUESTBOOK_IS_OFFLINE_VALUE}'] = cf_getOptionYN($tmp_isOffline, $langMsg['Yes'], $langMsg['No']);
$tplVars['{OFFLINE_MESSAGE_VALUE}'] = $tmp_offlineMsg;
$tplVars['{APPROVE_COMMENTS_VALUE}'] = cf_getOptionYN($tmp_toApproveComment, $langMsg['Yes'], $langMsg['No']);
$tplVars['{NOTIFICATION_EMAIL_VALUE}'] = $tmp_notificationEmail;
$tplVars['{SHOW_LANGBOX_VALUE}'] = cf_getOptionYN($tmp_showLangBox, $langMsg['Yes'], $langMsg['No']);
$tplVars['{SHOW_VERIFICATION_CODE_VALUE}'] = cf_getOptionYN($tmp_showSecCode, $langMsg['Yes'], $langMsg['No']);
$tplVars['{SHOW_WEBSITE_FIELD_VALUE}'] = cf_getOptionYN($tmp_showWebsiteField, $langMsg['Yes'], $langMsg['No']);
$tplVars['{SHOW_EMAIL_FIELD_VALUE}'] = cf_getOptionYN($tmp_showEmailField, $langMsg['Yes'], $langMsg['No']);
$tplVars['{SHOW_LOCATION_FIELD_VALUE}'] = cf_getOptionYN($tmp_showLocationField, $langMsg['Yes'], $langMsg['No']);
$tplVars['{COMMENTS_PER_PAGE_VALUE}'] = $tmp_commentsPPage;
$tplVars['{CHARACTERS_PER_COMMENT_VALUE}'] = $tmp_maxCommentChars;
$tplVars['{PARAGRAPHS_PER_COMMENT_VALUE}'] = $tmp_maxCommentBreakLines;
$tplVars['{FLOOD_TIME_LIMIT_VALUE}'] = $tmp_timeBeforePostAgain;
$tplVars['{ALLOW_BAD_WORDS_VALUE}'] = cf_getOptionYN($tmp_allowBadWords, $langMsg['Yes'], $langMsg['No']);
$tplVars['{ALLOW_AMCODE_VALUE}'] = cf_getOptionYN($tmp_allowAMcode, $langMsg['Yes'], $langMsg['No']);
$tplVars['{ALLOW_SMILEYS_VALUE}'] = cf_getOptionYN($tmp_allowSmileys, $langMsg['Yes'], $langMsg['No']);

echo (new templateParser("../$tplPath/tpl/configBody.html", $tplVars));

if (count($pageError) > 0) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	$tplVars['{SERVER_MESSAGE}'] = '';	
	for ($i=0; $i<count($pageError); $i++)
		$tplVars['{SERVER_MESSAGE}'] .= "<p>$pageError[$i]</p>";

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 1) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Configuration_saved'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin CP footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>