<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Index page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    02/12/2009
// Updated: 01/04/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: index.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

//------------------
// Begin page source
//------------------
$fileWarning = array();
$_SESSION['sesCommentType'] = 0;

if ($action == 'loginACP') {
	$tmpUserName = strtolower(htmlentities($_POST['userName'], ENT_QUOTES));
	$tmpUserPass = md5(htmlentities($_POST['userPass'], ENT_QUOTES));
	$iFound = 0;
	$userId = 0;

	$userFile = new fileManager('../'.$cf_dataPath.'/users.php', 'r');	
	for ($i=1; $i<$userFile->getRows(); $i++) {
		$arrData = explode('|', $userFile->getDataRow($i));
		
		if (strtolower($arrData[1]) == $tmpUserName && $arrData[2] == $tmpUserPass) {
			$iFound = 1;
			$userId = $arrData[0];
			break;
		}
	}
	
	if ($iFound  == 1) {
		if (isset($_SESSION['Lang']))
			unset($_SESSION['Lang']);
	
		$_SESSION['sesIsLogged'] = 1;
		$_SESSION['sesUserId'] = $userId;
		$_SESSION['sesUserPass'] = $tmpUserPass;
		header("Location: index.php");
		die();
	} else
		$attempts++;
}

// Checking data files permissions
if (!is_writable('../'.$cf_dataPath.'/config.php'))
	$fileWarning[] = '<b>config.php</b>';
if (!is_writable('../'.$cf_dataPath.'/users.php'))
	$fileWarning[] = '<b>users.php</b>';
if (!is_writable('../'.$cf_dataPath.'/comments.php'))
	$fileWarning[] = '<b>comments.php</b>';
if (!is_writable('../'.$cf_dataPath.'/smileys'))
	$fileWarning[] = '<b>smileys</b>';
if (!is_writable('../'.$cf_dataPath.'/cwordsLog'))
	$fileWarning[] = '<b>cwordsLog</b>';
if (!is_writable('../'.$cf_dataPath.'/ipLog'))
	$fileWarning[] = '<b>ipLog</b>';
if (!is_writable('../'.$cf_dataPath.'/spamLog'))
	$fileWarning[] = '<b>spamLog</b>';
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin header
$mainTpl->showHeader($isLogged);

if ($isLogged == 1) {
	// Admin CP main page
	$tplVars['{MAIN_MENU}'] = $langMsg['Main_menu'];
	$tplVars['{CONFIGURATION}'] = $langMsg['Configuration'];
	$tplVars['{USER_PROFILE}'] = $langMsg['User_profile'];
	$tplVars['{MANAGE_COMMENTS}'] = $langMsg['Manage_comments'];	
	$tplVars['{MANAGE_SMILEYS}'] = $langMsg['Manage_smileys'];
	$tplVars['{MANAGE_CENSORED_WORDS_LIST}'] = $langMsg['Manage_censored_words_list'];
	$tplVars['{MANAGE_SPAM_LOG}'] = $langMsg['Manage_spam_log'];
	$tplVars['{BAN_IP_ADDRESS}'] = $langMsg['Ban_ip_address'];
	$tplVars['{VIEW_MY_GUESTBOOK}'] = $langMsg['View_my_guestbook'];	
	$tplVars['{APP_VERSION_TEXT}'] = $langMsg['Version'];
	$tplVars['{APP_NAME}'] = $cf_appName.' '.$cf_appProduct;
	$tplVars['{APP_VERSION}'] = $cf_appVersion;
	
	echo (new templateParser("../$tplPath/tpl/indexBody.html", $tplVars));
}
else {
	// Login form
	$tplVars['{PLEASE_LOGIN}'] = $langMsg['Please_login'];
	$tplVars['{LOGIN}'] = $langMsg['Login'];
	$tplVars['{USERNAME}'] = $langMsg['Username'];
	$tplVars['{PASSWORD}'] = $langMsg['Password'];	

	echo (new templateParser("../$tplPath/tpl/loginBody.html", $tplVars));

	if ($attempts > 0) {
		// Warning message
		$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
		$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Login_warn'].'</p>';	

		echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
	}
}

if (count($fileWarning) > 0) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['No_writing_permissions'].'</p>';	
	for ($i=0; $i<count($fileWarning); $i++)
		$tplVars['{SERVER_MESSAGE}'] .= "<p>$fileWarning[$i] - ".$langMsg['Is_read_only'].'</p>';

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>