<?php
//---------------------------------------------------------------------
//  -- Adriel Media --
//---------------------------------------------------------------------
// Admin Control Panel * Edit comment page
// Product: Faisan Guestbook
// Written by: Adriel Ricardo Torres aka RicarDooM
// Website: http://adrielmedia.com
// Date:    05/02/2010
// Updated: 01/04/2010
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// File name: edit_comment.php
// File version: 1.0
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//---------------------------------------------------------------------
require_once('adminHeader.php');

if ($isLogged != 1)
	header("Location: index.php");
//------------------
// Begin page source
//------------------
$pageError = array();
$actionMade = 0;
$commentType = 0;
$commentFile = new fileManager('../'.$cf_dataPath.'/comments.php', 'r');
$strToInsert = '';
$smileyFile = new fileManager('../'.$cf_dataPath.'/smileys', 'r');
$strSmileys = '';
$smileyUrl = '';
$arrData = array();
$thisComment = new commentsVO();
$thisUser = new usersVO();

if (isset($_GET['id']))
	$thisComment->setCommentId(htmlentities($_GET['id'], ENT_QUOTES));
elseif (isset($_POST['id']))
	$thisComment->setCommentId(htmlentities($_POST['id'], ENT_QUOTES));

for ($i = 0; $i < $commentFile->getRows(); $i++) {
	$arrData = explode('|', $commentFile->getDataRow($i));

	if ($arrData[0] == $thisComment->getCommentId()) {
		$thisComment->setCommentBody($arrData[1]);
		$thisComment->setCommentDate($arrData[3]);
		$thisUser->setUserName($arrData[4]);
		$thisUser->setUserIp($arrData[5]);
		$thisUser->setUserEmail($arrData[6]);
		$thisUser->setUserWebsite($arrData[7]);
		$thisUser->setUserLocation($arrData[8]);
		break;
	}
}

if ($action == $langMsg['Save_changes'] && is_writable('../'.$cf_dataPath.'/comments.php')) {
	$thisUser->setUserLocation(cf_replaceSpTags(htmlentities($_POST['userLocation'], ENT_QUOTES)));
				
	$tmpUserName = htmlentities($_POST['userName'], ENT_QUOTES);
	if (cf_validateRequiredField($tmpUserName) != 0)
		$pageError[] = $langMsg['Name_warn'];
				
	$thisUser->setUserName(cf_replaceSpTags($tmpUserName));
				
	$tmpUserEmail = htmlentities($_POST['userEmail'], ENT_QUOTES);
	if (cf_validateEmail($tmpUserEmail) != 0)
		$pageError[] = $langMsg['Email_warn'];

	$thisUser->setUserEmail(cf_replaceSpTags($tmpUserEmail));
				
	$tmpUserWebsite = htmlentities($_POST['userWebsite'], ENT_QUOTES);
	if (cf_validateWebsite($tmpUserWebsite) != 0)
		$pageError[] = $langMsg['Website_warn'];

	$thisUser->setUserWebsite(cf_replaceSpTags($tmpUserWebsite));
			
	$tmpComment = htmlentities($_POST['commentBody'], ENT_QUOTES);
	if (cf_validateRequiredField($tmpComment) != 0)
		$pageError[] = $langMsg['Comment_warn'];

	$thisComment->setCommentBody(cf_replaceSpTags($tmpComment));

	// Updating user profile
	if (count($pageError) == 0) {
		for ($i = 0; $i < $commentFile->getRows(); $i++) {
			$arrData = explode("|", $commentFile->getDataRow($i));

			if ($arrData[0] == $_SESSION['sesUserId'])
				$strToInsert .= $arrData[0].'|'.
								cf_parseBreaklines($thisComment->getCommentBody()).'|'.
								$arrData[2].'|'.
								$arrData[3].'|'.
								$thisUser->getUserName().'|'.
								$arrData[5].'|'.
								$thisUser->getUserEmail().'|'.
								$thisUser->getUserWebsite().'|'.
								$thisUser->getUserLocation().'|'.
								$arrData[9].'|'."\n";
			else
				$strToInsert .= $commentFile->getDataRow($i);
		}
			
		$debug[] = "$strToInsert\n";
		$saveFile = new fileManager('../'.$cf_dataPath.'/comments.php', 'w');
		$saveFile->saveData($strToInsert);
		$actionMade = 1;
	}
}
//------------------
// End page source
//------------------
//******************
//------------------
// Begin page output
//------------------
if (defined('DEBUG')) {
	echo "<!--\n";
	for ($i=0; $i<count($debug); $i++)
		echo $debug[$i];
	echo "-->\n";
}

// Showing admin header
$mainTpl->showHeader($isLogged);

// Edit comment body
$tplVars['{EDIT_COMMENT}'] = $langMsg['Edit_comment'];
$tplVars['{NAME}'] = $langMsg['Name'];
$tplVars['{LOCATION}'] = $langMsg['Location'];
$tplVars['{EMAIL}'] = $langMsg['Email'];
$tplVars['{WEBSITE}'] = $langMsg['Website'];
$tplVars['{NAME_VALUE}'] = $thisUser->getUserName();
$tplVars['{LOCATION_VALUE}'] = $thisUser->getUserLocation();
$tplVars['{EMAIL_VALUE}'] = $thisUser->getUserEmail();
$tplVars['{WEBSITE_VALUE}'] = $thisUser->getUserWebsite();
$tplVars['{COMMENT}'] = cf_parseBrTags($thisComment->getCommentBody());
$tplVars['{SAVE_CHANGES}'] = $langMsg['Save_changes'];
$tplVars['{TEXT_COLOR}'] = $langMsg['Text_color'];
$tplVars['{RED}'] = $langMsg['Red'];
$tplVars['{BLUE}'] = $langMsg['Blue'];
$tplVars['{GREEN}'] = $langMsg['Green'];
$tplVars['{YELLOW}'] = $langMsg['Yellow'];
$tplVars['{ORANGE}'] = $langMsg['Orange'];
$tplVars['{RESTORE}'] = $langMsg['Restore'];

for ($i=0; $i<$smileyFile->getRows(); $i++) {
	$arrSmiley = explode('|', $smileyFile->getDataRow($i));
	
	if (preg_match("/^[http:\/\/]/i", $arrSmiley[2]))
		$smileyUrl = $arrSmiley[2];
	else
		$smileyUrl = '../'.$arrSmiley[2];
	
	$strSmileys .= '<a href="#" onclick="js_changeString(\''.$arrSmiley[1].'\', \'commentBody\')"><img src="'.$smileyUrl.'" border="0" alt="'.$arrSmiley[3].'" /></a> ';
}
$tplVars['{SMILEY_LIST}'] = $strSmileys;

echo (new templateParser("../$tplPath/tpl/editcommentBody.html", $tplVars));

if (count($pageError) > 0) {
	// Warning message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'warningMessage';
	$tplVars['{SERVER_MESSAGE}'] = '';	
	for ($i=0; $i<count($pageError); $i++)
		$tplVars['{SERVER_MESSAGE}'] .= "<p>$pageError[$i]</p>";

	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
} elseif ($actionMade == 1) {
	// Server message
	$tplVars['{SERVER_MESSAGE_CLASS}'] = 'serverMessage';
	$tplVars['{SERVER_MESSAGE}'] = '<p>'.$langMsg['Edit_message'].'</p>';
	echo (new templateParser("../$tplPath/tpl/serverMessage.html", $tplVars));
}

// Showing admin footer
$mainTpl->showFooter();
//----------------
// End page output
//----------------
?>